import openpyxl

from anylogic_design_time_api import *
from anylogic_design_time_api.generated import *

def gen_conveyors_from_excel(excel_file_path, excel_sheet, level):

    conveyors = []
    wb = openpyxl.load_workbook(excel_file_path)

    conv_sheet = wb[excel_sheet]
    for r in conv_sheet.iter_rows(min_row = 2):
        #create conveyor markup
        conveyor = Conveyor.create(level)

        #set coordinates of conveyor's start
        conveyor.setX(r[0].value)
        conveyor.setY(r[1].value)
        conveyor.setZ(r[2].value)

        #read and create a set of points for conveyor segments
        points_data = r[3].value
        points = [float(num) for num in points_data.strip('{} ').split(',')]
        pointList = Utils.createStraightPointsList(conveyor, points)
        conveyor.setPointList(pointList)

        #set conveyor markup properties
        conveyor.setWidth(float(r[5].value), LengthUnits.METER) #float argument is used for static field
        conveyor.setMaxSpeed(str(r[6].value), SpeedUnits.MPS)
        conveyor.setGap(str(r[7].value), LengthUnits.METER) #string argument is used for code field

        conveyors.append(conveyor)

    return conveyors

def gen_paths_from_excel(excel_file_path, excel_sheet, level):

    paths = []
    wb = openpyxl.load_workbook(excel_file_path)

    path_sheet = wb[excel_sheet]

    for r in path_sheet.iter_rows(min_row = 2):

        #create paths
        path = Path.create(level)

        #set coordinates of path's start
        path.setX(r[0].value)
        path.setY(r[1].value)
        path.setZ(r[2].value)

        #read and create a set of points for conveyor segments
        points_data = r[3].value
        points = [float(num) for num in points_data.strip('{} ').split(',')]
        pointList = Utils.createStraightPointsList(path, points)
        path.setPointList(pointList)

        paths.append(path)

    return paths

def gen_nodes_from_excel(excel_file_path, excel_sheet, level, paths):

    nodes = []
    wb = openpyxl.load_workbook(excel_file_path)

    node_sheet = wb[excel_sheet]

    for r in node_sheet.iter_rows(min_row = 2):

        #create nodes
        node = PointNode.create(level)

        #set coordinates of the node
        node.setX(r[0].value)
        node.setY(r[1].value)
        node.setZ(r[2].value)

        #connect outcoming paths to node
        if (r[3].value):
            paths[int(r[3].value)].setSource(node)

        #connect incoming paths to node
        if (r[4].value):
            print(r[4].value)
            inpaths_data = r[4].value
            inpaths_id = [path_id for path_id in str(inpaths_data).strip('').split(',')]
            for path_id in inpaths_id:
                print(paths[int(path_id)].getName())
                paths[int(path_id)].setTarget(node)

        nodes.append(node)

    return nodes

ws = Workspace('8c27e7e6-961a-49b6-b796-13a609e22438') #connect to the AnyLogic using token that was copied from AnyLogic
modelName = 'Model2' #name of the model in AnyLogic in which the markup is generated
model = ws.getModel(modelName) #specify the model in which markup is created
agent = model.getAgent('Main') #specify Agent in which markup is created
level = agent.getLevels()[0] #specify level in which markup is created

# space markup
# add conveyors
conveyors = gen_conveyors_from_excel('network_data.xlsx', 'conveyors', level)

# add stations
# stations = gen_stations_from_excel('network_data.xlsx', 'stations', conveyors)

# add paths
paths = gen_paths_from_excel('network_data.xlsx', 'paths', level)

# add nodes
nodes = gen_nodes_from_excel('network_data.xlsx', 'nodes', level, paths)

# add turnstation
turnStation = TurnStation.create(agent)
turnStation.setX(210)
turnStation.setY(200)
conveyors[0].setTarget(turnStation)
conveyors[1].setSource(turnStation)

# add station
station = ConveyorSimpleStation.create(conveyors[2])

# curve conveyor segment 
Utils.toggleArcSegment(conveyors[0], 1)

#add robot
robot = Robot.create(agent)
robot.setX(315.0)
robot.setY(200.0)
robot.setInitialEndEffectorX(295)
robot.setInitialEndEffectorY(200)
robot.setMaximumArmReach(3.0, LengthUnits.METER)
robot.setLinksColor(Utils.getIntFromRGB(218, 165, 32))
 